using System.Collections.Generic;
using System.Windows.Forms;
#if NUNIT

#region References

using System;
using System.Collections;
using System.Text;

using NUnit.Framework;

using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.DAL.HL7AL;
using gov.va.med.vbecs.DAL.HL7.OpenLibrary;
using gov.va.med.vbecs.DAL.HL7.OpenLibrary.Messages;

using gov.va.med.vbecs.UnitTests;

#endregion

namespace gov.va.med.vbecs.DAL.HL7.UnitTests.OpenLibrary.Messages
{
	[TestFixture]
	public class Messages_HL7AIOruMessage_ObrSegment  : BaseTest
	{
		#region Variables & Setup

        private static string _hl7Message;

		private HL7AIOruMessage.ObrSegment _obrSegment;


        static Messages_HL7AIOruMessage_ObrSegment()
		{
            
		}

	    [SetUp]
	    public void SetUp()
	    {
	        _hl7Message = string.Concat(
	            "MSH|^~\\&|IM|589|VBECS|589|20080526135401-0500||ORU^R01|1048|P|2.4|6||AL|NE",
	            CARRIAGE_RETURN,
	            "OBR|1|2953060005^OR||TAS|||||||||||||||ProVueSanDiego",
	            CARRIAGE_RETURN,
	            "OBX|1||AntiA||4+||||||F|||20151102085842||DNS   dobrak",
	            CARRIAGE_RETURN,
	            "OBX|2||SC2||0||||||F|||20151102085842||DNS   dobrak",
	            CARRIAGE_RETURN,
	            "OBX|3||ABSInterp||Neg||||||F|||20151102085842||DNS   dobrak",
	            CARRIAGE_RETURN,
	            "OBX|4||Comment||Testing Comment||||||F|||20151102085842||DNS   dobrak",
	            CARRIAGE_RETURN,
	            "OBX|5||AntiB||3+||||||F|||20151102085842||DNS   dobrak",
	            CARRIAGE_RETURN,
	            "OBX|6||A1Cells||0||||||F|||20151102085842||DNS   dobrak",
	            CARRIAGE_RETURN,
	            "OBX|7||BCells||0||||||F|||20151102085842||DNS   dobrak",
	            CARRIAGE_RETURN,
	            "OBX|8||AntiD||4+||||||F|||20151102085842||DNS   dobrak",
	            CARRIAGE_RETURN,
	            "OBX|9||DControl||0||||||F|||20151102085842||DNS   dobrak",
	            CARRIAGE_RETURN,
	            "OBX|10||ABOInterp||AB||||||F|||20151102085842||DNS   dobrak",
	            CARRIAGE_RETURN,
	            "OBX|11||RhInterp||Pos||||||F|||20151102085842||DNS   dobrak",
	            CARRIAGE_RETURN,
	            "OBX|12||SC1||0||||||F|||20151102085842||DNS   dobrak",
	            CARRIAGE_RETURN);
	    }

	    #endregion

		#region Constructors

		[Test]
		public void Ctor_Pass()
		{
            HL7AIOruMessage oruTestMessage = new HL7AIOruMessage(_hl7Message);
			//
			Assert.IsTrue( oruTestMessage != null );
		}

		[Test]
		[ExpectedException( typeof( ArgumentNullException ) )]
		public void Ctor_Fail()
		{
			HL7AIOruMessage oruMessage = new HL7AIOruMessage( null );
			//
			Assert.IsTrue( oruMessage != null );
		}

		#endregion

		#region Methods


		#endregion

		#region Properties


		#endregion
            [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void get_OBRFieldsTest()
    {
        // TODO: Implement unit test for get_OBRFieldsTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void set_OBRFieldsTest()
    {
        // TODO: Implement unit test for set_OBRFieldsTest
    }
    
    [NUnit.Framework.TestAttribute()]
    void SequenceNumberTest_Pass()
    {
        string obr = "OBR|1|2953060005^||TAS|||||||||||||||ProVueSanDiego";
        List<string> errors = new List<string>();

        _obrSegment = new HL7AIOruMessage.ObrSegment(obr,'|', '^', ref errors);

        Assert.IsTrue(_obrSegment.SequenceNumber != 0);

    }

    [NUnit.Framework.TestAttribute()]
    void SequenceNumberTest_Missing()
    {
        string obr = "OBR||2953060005^||TAS|||||||||||||||ProVueSanDiego";
        List<string> errors = new List<string>();

        _obrSegment = new HL7AIOruMessage.ObrSegment(obr, '|', '^', ref errors);

        Assert.IsTrue(errors.Count == 1 && errors[0].Contains("OBR Sequence Number Not Valid"));
    }

    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void set_SequenceNumberTest()
    {
        // TODO: Implement unit test for set_SequenceNumberTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void get_TestNameTest()
    {
        // TODO: Implement unit test for get_TestNameTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void set_TestNameTest()
    {
        // TODO: Implement unit test for set_TestNameTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void get_SpecimenUidTest()
    {
        // TODO: Implement unit test for get_SpecimenUidTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void set_SpecimenUidTest()
    {
        // TODO: Implement unit test for set_SpecimenUidTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void get_UnitIdTest()
    {
        // TODO: Implement unit test for get_UnitIdTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void set_UnitIdTest()
    {
        // TODO: Implement unit test for set_UnitIdTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void get_InstrumentNameTest()
    {
        // TODO: Implement unit test for get_InstrumentNameTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void set_InstrumentNameTest()
    {
        // TODO: Implement unit test for set_InstrumentNameTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void get_TestCommentTest()
    {
        // TODO: Implement unit test for get_TestCommentTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void set_TestCommentTest()
    {
        // TODO: Implement unit test for set_TestCommentTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void ToStringTest()
    {
        // TODO: Implement unit test for ToStringTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void EqualsTest()
    {
        // TODO: Implement unit test for EqualsTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void GetHashCodeTest()
    {
        // TODO: Implement unit test for GetHashCodeTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void GetTypeTest()
    {
        // TODO: Implement unit test for GetTypeTest
    }

	}
}
#endif